<?php
session_start();
include_once(dirname(__FILE__).'/inc/config.php');
include_once(dirname(__FILE__).'/inc/settings.php');
include_once(dirname(__FILE__).'/inc/icdb.php');
include_once(dirname(__FILE__).'/inc/functions.php');
$icdb = new ICDB(DB_HOST, DB_NAME, DB_USER, DB_PASSWORD, TABLE_PREFIX);

$is_logged = false;
$session_id = '';
if (isset($_COOKIE['aiosp-auth'])) {
	$session_id = preg_replace('/[^a-zA-Z0-9]/', '', $_COOKIE['aiosp-auth']);
	$session_details = $icdb->get_row("SELECT * FROM ".$icdb->prefix."sessions WHERE session_id = '".$session_id."' AND registered + valid_period > '".time()."'");
	if ($session_details) {
		$icdb->query("UPDATE ".$icdb->prefix."sessions SET registered = '".time()."' WHERE session_id = '".$session_id."'");
		$is_logged = true;
	}
}

install();
get_options();

if (isset($_SESSION['error'])) {
	$error_message = $_SESSION['error'];
	unset($_SESSION['error']);
} else $error_message = '';
if (isset($_SESSION['ok'])) {
	$ok_message = $_SESSION['ok'];
	unset($_SESSION['ok']);
} else $ok_message = '';

$pages = array (
	'settings' => 'Settings',
	'subscribers' => 'Subscribers',
	'embed' => 'Embedding'
);
$deafult_page = 'subscribers';
if ($is_logged) {
	if (isset($_GET['action'])) {
		switch ($_GET['action']) {
			case 'getresponse-campaigns':
				$options['getresponse_api_key'] = trim(stripslashes($_POST['getresponse_api_key']));
				$html_object = new stdClass();
				$campaigns = getresponse_getcampaigns();
				if (sizeof($campaigns) > 0) {
					$getresponse_options = '';
					foreach ($campaigns as $key => $value) {
						$getresponse_options .= '<option value="'.$key.'"'.($key == $options['getresponse_campaign_id'] ? ' selected="selected"' : '').'>'.htmlspecialchars($value, ENT_QUOTES).'</option>';
					}
					$html_object->options = $getresponse_options;
				} else {
					$html_object->options = '<option>-- No campaigns found --</option>';
				}
				echo json_encode($html_object);
				exit;
				break;
		
			case 'icontact-lists':
				$options['icontact_appid'] = trim(stripslashes($_POST['icontact_appid']));
				$options['icontact_apiusername'] = trim(stripslashes($_POST['icontact_apiusername']));
				$options['icontact_apipassword'] = trim(stripslashes($_POST['icontact_apipassword']));
				$html_object = new stdClass();
				$lists = icontact_getlists();
				if (sizeof($lists) > 0) {
					$icontact_options = '';
					foreach ($lists as $key => $value) {
						$icontact_options .= '<option value="'.$key.'"'.($key == $options['icontact_listid'] ? ' selected="selected"' : '').'>'.htmlspecialchars($value, ENT_QUOTES).'</option>';
					}
					$html_object->options = $icontact_options;
				} else {
					$html_object->options = '<option>-- No lists found --</option>';
				}
				echo json_encode($html_object);
				exit;
				break;
				
			case 'icontact-validate':
				$icontact_appid = trim(stripslashes($_POST['icontact_appid']));
				$icontact_apiusername = trim(stripslashes($_POST['icontact_apiusername']));
				$icontact_apipassword = trim(stripslashes($_POST['icontact_apipassword']));
				$data = icontact_makecall($icontact_appid, $icontact_apiusername, $icontact_apipassword, '/a/', null, 'accounts');
				if (!empty($data['errors'])) {
					die('<span class="label label-important">'.implode(' ', $data['errors']).'</span>');
				}
				$account = $data['response'][0];
				if (empty($account)) {
					die('<span class="label label-important">Account not found.</span>');
				} else if (intval($account->enabled != 1)) {
					die('<span class="label label-important">Your account has been disabled.</span>');
				}
				$data = icontact_makecall($icontact_appid, $icontact_apiusername, $icontact_apipassword, '/a/'.$account->accountId.'/c/', null, 'clientfolders');
				if (!empty($data['errors'])) {
					die('<span class="label label-important">'.implode(' ', $data['errors']).'</span>');
				}
				$client = $data['response'][0];
				if (empty($client)) {
					die('<span class="label label-important">No client folders were found for this account.</span>');
				}
				die('<span class="label label-success">Parameters validated! AccountID = '.$account->accountId.'. ClientFolderID = '.$client->clientFolderId.'.</span>');
				break;
		
			case 'logout':
				if (!empty($session_id)) {
					$icdb->query("UPDATE ".$icdb->prefix."sessions SET valid_period = '0' WHERE session_id = '".$session_id."'");
				}
				header('Location: admin.php');
				exit;
				break;

			case 'update-options':
				if (DEMO_MODE) {
					$_SESSION['error'] = 'DEMO MODE: This operation is disabled.';
					header('Location: admin.php?page=settings');
					exit;
				}
				if (isset($_POST['action']) && $_POST['action'] == 'update-options') {
					populate_options();
					if (isset($_POST["load_enable"])) $options['load_enable'] = "on";
					else $options['load_enable'] = "off";
					if (isset($_POST["exit_enable"])) $options['exit_enable'] = "on";
					else $options['exit_enable'] = "off";
					if (isset($_POST["copy_enable"])) $options['copy_enable'] = "on";
					else $options['copy_enable'] = "off";
					if (isset($_POST["scroll_enable"])) $options['scroll_enable'] = "on";
					else $options['scroll_enable'] = "off";
					if (isset($_POST["idle_enable"])) $options['idle_enable'] = "on";
					else $options['idle_enable'] = "off";
					if (isset($_POST["context_enable"])) $options['context_enable'] = "on";
					else $options['context_enable'] = "off";
					if (isset($_POST["disable_name"])) $options['disable_name'] = "on";
					else $options['disable_name'] = "off";
					if (isset($_POST["scroll_once_per_visit"])) $options['scroll_once_per_visit'] = "on";
					else $options['scroll_once_per_visit'] = "off";
					if (isset($_POST["disable_mobile"])) $options['disable_mobile'] = "on";
					else $options['disable_mobile'] = "off";
					if (isset($_POST["load_disable_close"])) $options['load_disable_close'] = "on";
					else $options['load_disable_close'] = "off";
					if (isset($_POST["load_once_per_visit"])) $options['load_once_per_visit'] = "on";
					else $options['load_once_per_visit'] = "off";
					if (isset($_POST["copy_block"])) $options['copy_block'] = "on";
					else $options['copy_block'] = "off";
					if (isset($_POST["mailchimp_double"])) $options['mailchimp_double'] = "on";
					else $options['mailchimp_double'] = "off";
					if (isset($_POST["mailchimp_welcome"])) $options['mailchimp_welcome'] = "on";
					else $options['mailchimp_welcome'] = "off";
					if (isset($_POST["mailchimp_enable"])) $options['mailchimp_enable'] = "on";
					else $options['mailchimp_enable'] = "off";
					if (isset($_POST["icontact_enable"])) $options['icontact_enable'] = "on";
					else $options['icontact_enable'] = "off";
					if (isset($_POST["getresponse_enable"])) $options['getresponse_enable'] = "on";
					else $options['getresponse_enable'] = "off";
					if (isset($_POST["campaignmonitor_enable"])) $options['campaignmonitor_enable'] = "on";
					else $options['campaignmonitor_enable'] = "off";
					$errors = check_options();
					if (isset($_POST['password'])) $password = trim($_POST['password']);
					else $password = '';
					if (isset($_POST['confirm_password'])) $confirm_password = trim($_POST['confirm_password']);
					else $confirm_password = '';
					if (get_magic_quotes_gpc()) {
						$password = stripslashes($password);
						$confirm_password = stripslashes($confirm_password);
					}
					if (!empty($password)) {
						if ($password == $confirm_password) {
							$options['password'] = md5($password);
						} else {
							if ($errors === true) $errors = array('Password and its confirmation are not equal');
							else $errors[] = 'Password and its confirmation are not equal';
						}
					}
					update_options();
					if (is_array($errors)) {
						$_SESSION['error'] = 'The following error(s) exists:<ul><li>'.implode('</li><li>', $errors).'</li></ul>';
					} else {
						$_SESSION['ok'] = 'Settings successfully saved!';
					}
				}
				header('Location: admin.php?page=settings');
				exit;
				break;
			
			case 'delete':
				if (DEMO_MODE) {
					$_SESSION['error'] = 'DEMO MODE: This operation is disabled.';
					header('Location: admin.php?page=subscribers');
					exit;
				}
				$id = intval($_GET["id"]);
				$user_details = $icdb->get_row("SELECT * FROM ".$icdb->prefix."users WHERE id = '".$id."' AND deleted = '0'");
				if (intval($user_details["id"]) == 0) {
					$_SESSION['error'] = 'Record not found!';
					header('Location: admin.php?page=subscribers');
					exit;
				}
				$sql = "UPDATE ".$icdb->prefix."users SET deleted = '1' WHERE id = '".$id."'";
				if ($icdb->query($sql) !== false) {
					$_SESSION['ok'] = 'Record successfully deleted!';
				} else {
					$_SESSION['error'] = 'Record can not be deleted!';
				}
				header('Location: admin.php?page=subscribers');
				exit;
				break;

			case 'delete-all':
				if (DEMO_MODE) {
					$_SESSION['error'] = 'DEMO MODE: This operation is disabled.';
					header('Location: admin.php?page=subscribers');
					exit;
				}
				$sql = "UPDATE ".$icdb->prefix."users SET deleted = '1' WHERE deleted = '0'";
				if ($icdb->query($sql) !== false) {
					$_SESSION['ok'] = 'All records successfully deleted!';
				} else {
					$_SESSION['error'] = 'Records can not be deleted!';
				}
				header('Location: admin.php?page=subscribers');
				exit;
				break;

			case 'export':
				if (DEMO_MODE) {
					$_SESSION['error'] = 'DEMO MODE: This operation is disabled.';
					header('Location: admin.php?page=subscribers');
					exit;
				}
				$rows = $icdb->get_rows("SELECT * FROM ".$icdb->prefix."users WHERE deleted = '0' ORDER BY registered DESC");
				if (sizeof($rows) > 0) {
					if (strstr($_SERVER["HTTP_USER_AGENT"],"MSIE")) {
						header("Pragma: public");
						header("Expires: 0");
						header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
						header("Content-type: application-download");
						header("Content-Disposition: attachment; filename=\"emails.csv\"");
						header("Content-Transfer-Encoding: binary");
					} else {
						header("Content-type: application-download");
						header("Content-Disposition: attachment; filename=\"emails.csv\"");
					}
					$separator = $options['csv_separator'];
					if ($separator == 'tab') $separator = "\t";
					echo '"Name"'.$separator.'"E-Mail"'.$separator.'"Registered"'."\r\n";
					foreach ($rows as $row) {
						echo '"'.str_replace('"', '', $row["name"]).'"'.$separator.'"'.str_replace('"', "", $row["email"]).'"'.$separator.'"'.date("Y-m-d H:i:s", $row["registered"]).'"'."\r\n";
					}
					exit;
	            }
	            header("Location: admin.php?page=subscribers");
				exit;
				break;
			
			default:
				break;
		}
		header('Location: admin.php');
		exit;
	}
	if (isset($_GET['page'])) {
		$page = preg_replace('/[^a-zA-Z0-9]/', '', $_GET['page']);
		if (!array_key_exists($_GET['page'], $pages)) $page = $deafult_page;
	} else $page = $deafult_page;
} else {
	if (isset($_GET['action'])) {
		switch ($_GET['action']) {
			case 'getresponse-campaigns':
				die('<option>-- Session expired. Please refresh the page and log in again --</option>');
				break;
		
			case 'icontact-lists':
				die('<option>-- Session expired. Please refresh the page and log in again --</option>');
				break;
				
			case 'icontact-validate':
				die('<span class="label label-important">Session expired. Please refresh the page and log in again.</span>');
				break;
				
			case 'login':
				if (isset($_POST['password'])) $password = trim($_POST['password']);
				else $password = '';
				if (isset($_POST['login'])) $login = trim($_POST['login']);
				else $login = '';
				if (get_magic_quotes_gpc()) {
					$password = stripslashes($password);
					$login = stripslashes($login);
				}
				sleep(3);
				
				if ($login == $options['login'] && strtolower(md5($password)) == strtolower($options['password'])) {
					$symbols = '123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
					$session_id = "";
					for ($i=0; $i<16; $i++) {
						$session_id .= $symbols[rand(0, strlen($symbols)-1)];
					}
					$icdb->query("INSERT INTO ".$icdb->prefix."sessions (session_id, registered, valid_period) VALUES ('".$session_id."', '".time()."', '900')");
					setcookie('aiosp-auth', $session_id, time()+3600*24*180);
					$_SESSION['ok'] = 'Welcome to admin panel!'.(DEMO_MODE ? ' Admin Panel operates in DEMO MODE for security reasons.' : '');
				} else $_SESSION['error'] = 'Invalid login or password!';
				header('Location: admin.php');
				exit;
				break;
				
			default:
				break;
		}
		header('Location: admin.php');
		exit;
	}
	$page = 'login';
}
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo (array_key_exists($page, $pages) ? $pages[$page] : 'Login').' - '; ?>All-in-One Subscribe Popup</title>
	<meta charset="utf-8">
	<link href="css/bootstrap.min.css" rel="stylesheet">
	<link href="css/style.css" rel="stylesheet">
	<script src="js/jquery-1.8.3.min.js"></script>
</head>
<body>
<!-- Header - begin -->
<div class="navbar navbar-fixed-top navbar-inverse">
	<div class="navbar-inner">
		<div class="container">
			<a class="brand" href="#">All-in-One Subscribe Popup</a>
<?php
			if ($is_logged) echo '
			<a class="navbar-text pull-right" href="admin.php?action=logout">Logout</a>';
			else echo '
			<a class="navbar-text pull-right" href="admin.php?page=login">Login</a>';
			if ($is_logged) {
?>
			<ul class="nav">
<?php
				foreach ($pages as $key => $value) {
					echo '
				<li'.($key == $page ? ' class="active"' : '').'><a href="admin.php?page='.$key.'">'.$value.'</a></li>';
				}
?>
			</ul>
<?php
			}
?>
		</div>
	</div>
</div>
<!-- Header - end -->

<div class="container" style="margin-top: 40px; margin-bottom: 40px;">
<?php
	if ($page == 'settings') {
		if (empty($error_message)) {
			$errors = check_options();
			if (is_array($errors)) $message = '<div class="alert alert-error">The following error(s) exists:<ul><li>'.implode('</li><li>', $errors).'</li></ul></div>';
			else if (!empty($ok_message)) $message = '<div class="alert alert-success">'.$ok_message.'</div>';
			else $message = '';
		} else $message = '<div class="alert alert-error">'.$error_message.'</div>';
		echo $message;
?>
	<form enctype="multipart/form-data" method="post" action="admin.php?action=update-options">
		<h3>General Settings</h3>
		<div class="row">
			<div class="span3"><strong>Popup box content:</strong></div>
			<div class="span9">
				<textarea class="span9" rows="5" id="message" name="message"><?php echo htmlspecialchars($options['message'], ENT_QUOTES); ?></textarea>
				<br /><small>Please enter content of popup box. HTML allowed. Opt-in form is inserted below this content.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Popup box size (px):</strong></div>
			<div class="span9">
				<input type="text" class="input-mini" id="width" name="width" value="<?php echo htmlspecialchars($options['width'], ENT_QUOTES); ?>" style="text-align: right;"> x
				<input type="text" class="input-mini" id="height" name="height" value="<?php echo htmlspecialchars($options['height'], ENT_QUOTES); ?>" style="text-align: right;">
				<br /><small>Please set popup size (width x height). Minimum size is 200 x 50 pixels.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Popup box color:</strong></div>
			<div class="span9">
				<input type="text" class="input-small" id="popup_bg_color" name="popup_bg_color" value="<?php echo htmlspecialchars($options['popup_bg_color'], ENT_QUOTES); ?>" style="text-align: right;">
				<br /><small>Please set popup box background color.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Background image URL:</strong></div>
			<div class="span9">
				<input type="text" class="span9" id="popup_bg_url" name="popup_bg_url" value="<?php echo htmlspecialchars($options['popup_bg_url'], ENT_QUOTES); ?>">
				<br /><small>Enter your URL of background image. Leave this field blank if you do not need background image.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Font color scheme:</strong></div>
			<div class="span9">
				<select id="font_scheme" name="font_scheme" class="span2">
					<option value="dark" <?php echo $options['font_scheme'] == 'dark' ? ' selected="selected"' : ''; ?>>Dark</option>
					<option value="light" <?php echo $options['font_scheme'] == 'light' ? ' selected="selected"' : ''; ?>>Light</option>
				</select>
				<br /><small>Please select font color scheme.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Overlay color:</strong></div>
			<div class="span9">
				<input type="text" class="input-small" id="overlay_bg_color" name="overlay_bg_color" value="<?php echo htmlspecialchars($options['overlay_bg_color'], ENT_QUOTES); ?>" style="text-align: right;">
				<br /><small>Please set overlay color.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Overlay opacity:</strong></div>
			<div class="span9">
				<input type="text" class="input-small" id="overlay_opacity" name="overlay_opacity" value="<?php echo htmlspecialchars($options['overlay_opacity'], ENT_QUOTES); ?>" style="text-align: right;">
				<br /><small>Please set overlay opacity. Value must be between 0 and 1.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Small screen devices:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="disable_mobile" name="disable_mobile"<?php echo ($options['disable_mobile'] == 'on' ? ' checked="checked"' : ''); ?>"> Disable popup for small screen devices
				</label>
				<small>Please tick checkbox if you want to disable popup window for small screen devices.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>CSV column separator:</strong></div>
			<div class="span9">
				<select id="csv_separator" name="csv_separator">
					<option value=";"<?php echo ($options['csv_separator'] == ';' ? ' selected="selected"' : ''); ?>>Semicolon - ";"</option>
					<option value=","<?php echo ($options['csv_separator'] == ',' ? ' selected="selected"' : ''); ?>>Comma - ","</option>
					<option value="tab"<?php echo ($options['csv_separator'] == 'tab' ? ' selected="selected"' : ''); ?>>Tab</option>
				</select>
				<br /><small>Please select CSV column separator.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Disable "Name" field:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="disable_name" name="disable_name"<?php echo ($options['disable_name'] == 'on' ? ' checked="checked"' : ''); ?>"> Disable "Name" field in opt-in form
				</label>
				<small>Please tick checkbox if you want to disable "Name" field in opt-in form.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Stylesheet:</strong></div>
			<div class="span9">
				<textarea class="span9" rows="5" id="css" name="css"><?php echo htmlspecialchars($options['css'], ENT_QUOTES); ?></textarea>
				<br /><small>Customize popup box stylesheet.</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="hidden" name="action" value="update-options" />
				<input type="hidden" name="version" value="<?php echo VERSION; ?>" />
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
		<h3>MailChimp Settings</h3>
		<div class="row">
			<div class="span3"><strong>Enable MailChimp:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="mailchimp_enable" name="mailchimp_enable"<?php echo ($options['mailchimp_enable'] == 'on' ? ' checked="checked"' : ''); ?>"> Submit contact details to MailChimp
				</label>
				<small>Please tick checkbox if you want to submit contact details to MailChimp. <strong>CURL required!</strong></small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>MailChimp API Key:</strong></div>
			<div class="span9">
				<input type="text" class="span9" id="mailchimp_api_key" name="mailchimp_api_key" value="<?php echo htmlspecialchars($options['mailchimp_api_key'], ENT_QUOTES); ?>">
				<br /><small>Enter your MailChimp API Key. You can get it <a href="https://admin.mailchimp.com/account/api-key-popup" target="_blank">here</a>.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>List ID:</strong></div>
			<div class="span9">
				<input type="text" class="span4" id="mailchimp_list_id" name="mailchimp_list_id" value="<?php echo htmlspecialchars($options['mailchimp_list_id'], ENT_QUOTES); ?>">
				<br /><small>Enter your List ID. You can get it <a href="https://admin.mailchimp.com/lists/" target="_blank">here</a> (click <strong>Settings</strong>).</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Double opt-in:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="mailchimp_double" name="mailchimp_double"<?php echo ($options['mailchimp_double'] == 'on' ? ' checked="checked"' : ''); ?>"> Ask users to confirm their subscription
				</label>
				<small>Control whether a double opt-in confirmation message is sent.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Send Welcome:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="mailchimp_welcome" name="mailchimp_welcome"<?php echo ($options['mailchimp_welcome'] == 'on' ? ' checked="checked"' : ''); ?>"> Send List's Welcome message
				</label>
				<small>If <strong>Double opt-in</strong> is disabled and this is enabled, MailChimp will send list's Welcome Email if this subscribe succeeds. If <strong>Double opt-in</strong> is enabled, this has no effect.</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
		<h3>iContact Settings</h3>
		<div class="row">
			<div class="span3"><strong>Enable iContact:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="icontact_enable" name="icontact_enable"<?php echo ($options['icontact_enable'] == 'on' ? ' checked="checked"' : ''); ?>"> Submit contact details to iContact
				</label>
				<small>Please tick checkbox if you want to submit contact details to iContact. <strong>CURL required!</strong></small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>iContact AppID:</strong></div>
			<div class="span9">
				<input type="text" class="span9" id="icontact_appid" name="icontact_appid" value="<?php echo htmlspecialchars($options['icontact_appid'], ENT_QUOTES); ?>" onblur="icontact_loadlist();">
				<br /><small>Obtained when you <a href="http://developer.icontact.com/documentation/register-your-app/" target="_blank">Register the API application</a>. This identifier is used to uniquely identify your application.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>API Username:</strong></div>
			<div class="span9">
				<input type="text" class="span4" id="icontact_apiusername" name="icontact_apiusername" value="<?php echo htmlspecialchars($options['icontact_apiusername'], ENT_QUOTES); ?>" onblur="icontact_loadlist();">
				<br /><small>The iContact username for logging into your iContact account.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>API Password:</strong></div>
			<div class="span9">
				<input type="text" class="span4" id="icontact_apipassword" name="icontact_apipassword" value="<?php echo htmlspecialchars($options['icontact_apipassword'], ENT_QUOTES); ?>" onblur="icontact_loadlist();">
				<br /><small>The API application password set when the application was registered. This API password is used as input when your application authenticates to the API. This password is not the same as the password you use to log in to iContact.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Validate:</strong></div>
			<div class="span9">
				<input type="button" class="btn" value="Validate parameters" onclick="icontact_validate();" > <img id="icontact_progress" src="img/progress.gif" alt="" width="16" height="16" ><span id="icontact_status"></span>
				<br /><small>Click this button to make sure that entered values are valid.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>List:</strong></div>
			<div class="span9">
				<select class="span4" id="icontact_listid" name="icontact_listid">
					<option>-- Select List --</option>
				</select>
				<br /><small>Select desired List.</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
		<h3>GetResponse Settings</h3>
		<div class="row">
			<div class="span3"><strong>Enable GetResponse:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="getresponse_enable" name="getresponse_enable"<?php echo ($options['getresponse_enable'] == 'on' ? ' checked="checked"' : ''); ?>"> Submit contact details to GetResponse
				</label>
				<small>Please tick checkbox if you want to submit contact details to GetResponse. <strong>CURL required!</strong></small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>API Key:</strong></div>
			<div class="span9">
				<input type="text" class="span9" id="getresponse_api_key" name="getresponse_api_key" value="<?php echo htmlspecialchars($options['getresponse_api_key'], ENT_QUOTES); ?>" onblur="getresponse_loadlist();">
				<br /><small>Enter your GetResponse API Key. You can get your API Key <a href="https://app.getresponse.com/my_api_key.html" target="_blank">here</a>.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Campaign:</strong></div>
			<div class="span9">
				<select class="span4" id="getresponse_campaign_id" name="getresponse_campaign_id">
					<option>-- Select Campaign --</option>
				</select>
				<br /><small>Select desired Campaign.</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
		<h3>Campaign Monitor Settings</h3>
		<div class="row">
			<div class="span3"><strong>Enable Campaign Monitor:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="campaignmonitor_enable" name="campaignmonitor_enable"<?php echo ($options['campaignmonitor_enable'] == 'on' ? ' checked="checked"' : ''); ?>"> Submit contact details to Campaign Monitor
				</label>
				<small>Please tick checkbox if you want to submit contact details to Campaign Monitor. <strong>CURL required!</strong></small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>API Key:</strong></div>
			<div class="span9">
				<input type="text" class="span9" id="campaignmonitor_api_key" name="campaignmonitor_api_key" value="<?php echo htmlspecialchars($options['campaignmonitor_api_key'], ENT_QUOTES); ?>">
				<br /><small>Enter your Campaign Monitor API Key. You can get your API Key from the Account Settings page in your Campaign Monitor account.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>List ID:</strong></div>
			<div class="span9">
				<input type="text" class="span9" id="campaignmonitor_list_id" name="campaignmonitor_list_id" value="<?php echo htmlspecialchars($options['campaignmonitor_list_id'], ENT_QUOTES); ?>">
				<br /><small>Enter your List ID. You can get List ID from the list editor page in your Campaign Monitor account.</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
		<h3>OnPageLoad Popup Settings</h3>
		<div class="row">
			<div class="span3"><strong>Enable OnPageLoad Popup:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="load_enable" name="load_enable"<?php echo ($options['load_enable'] == 'on' ? ' checked="checked"' : ''); ?>"> Enable OnPageLoad popup
				</label>
				<small>Please tick checkbox if you want to enable OnPageLoad popup. OnPageLoad popup appears once user open page in browser.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Start delay (seconds):</strong></div>
			<div class="span9">
				<input type="text" class="input-small" id="load_start_delay" name="load_start_delay" value="<?php echo htmlspecialchars($options['load_start_delay'], ENT_QUOTES); ?>" style="text-align: right;">
				<br /><small>Popup appears with this delay after page loaded. Set "0" for immediate start.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Autoclose delay (seconds):</strong></div>
			<div class="span9">
				<input type="text" class="input-small" id="load_delay" name="load_delay" value="<?php echo htmlspecialchars($options['load_delay'], ENT_QUOTES); ?>" style="text-align: right;">
				<br /><small>Popup is automatically closed after this period of time. Set "0", if you do not need this functionality.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Once per visit:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="load_once_per_visit" name="load_once_per_visit"<?php echo ($options['load_once_per_visit'] == 'on' ? ' checked="checked"' : ''); ?>"> Show popup box once per visit
				</label>
				<small>Please tick checkbox if you want to show popup once per visit (session).</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Disable close button:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="load_disable_close" name="load_disable_close"<?php echo ($options['load_disable_close'] == 'on' ? ' checked="checked"' : ''); ?>"> Do not display close button
				</label>
				<small>Please tick checkbox disable close button.</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
		<h3>OnClickExternalLink Popup Settings</h3>
		<div class="row">
			<div class="span3"><strong>Enable OnClickExternalLink Popup:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="exit_enable" name="exit_enable"<?php echo ($options['exit_enable'] == 'on' ? ' checked="checked"' : ''); ?>"> Enable OnClickExternalLink popup
				</label>
				<small>Please tick checkbox if you want to enable OnClickExternalLink popup. OnClickExternalLink popup appears once user click any external link on page.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Redirect delay (seconds):</strong></div>
			<div class="span9">
				<input type="text" class="input-small" id="exit_delay" name="exit_delay" value="<?php echo htmlspecialchars($options['exit_delay'], ENT_QUOTES); ?>" style="text-align: right;">
				<br /><small>Please enter delay in seconds. Visitors have to wait this period of time or share your page to be redirected.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Excluded links:</strong></div>
			<div class="span9">
				<textarea class="span9" rows="5" id="exit_excluded_links" name="exit_excluded_links"><?php echo htmlspecialchars($options['exit_excluded_links'], ENT_QUOTES); ?></textarea>
				<br /><small>Please enter list of links that must be excluded from consideration (one item per line). You can enter part of link. For example, if you enter "wordpress.org", all links that contains this string will be excluded from consideration. Links are case insensitive.</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
		<h3>OnCopyContent Popup Settings</h3>
		<div class="row">
			<div class="span3"><strong>Enable OnCopyContent Popup:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="copy_enable" name="copy_enable"<?php echo ($options['copy_enable'] == 'on' ? ' checked="checked"' : ''); ?>"> Enable OnCopyContent popup
				</label>
				<small>Please tick checkbox if you want to enable OnCopyContent popup. OnCopyContent popup appears once user copy part of your page into clipboard (using Ctrl+C or through context menu).</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Block copying content:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="copy_block" name="copy_block"<?php echo ($options['copy_block'] == 'on' ? ' checked="checked"' : ''); ?>"> Do not copy content into clipboard if not shared
				</label>
				<small>Please tick checkbox if you do not want to allows copying content into clipboard until user shared your page.</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
		<h3>OnScrollDown Popup Settings</h3>
		<div class="row">
			<div class="span3"><strong>Enable OnScrollDown Popup:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="scroll_enable" name="scroll_enable"<?php echo ($options['scroll_enable'] == 'on' ? ' checked="checked"' : ''); ?>"> Enable OnScrollDown popup
				</label>
				<small>Please tick checkbox if you want to enable OnScrollDown popup. OnScrollDown popup appears once user scroll down current page.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Once per visit:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="scroll_once_per_visit" name="scroll_once_per_visit"<?php echo ($options['scroll_once_per_visit'] == 'on' ? ' checked="checked"' : ''); ?>"> Show popup box once per visit
				</label>
				<small>Please tick checkbox if you want to show popup once per visit (session).</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Scrolling offset (px):</strong></div>
			<div class="span9">
				<input type="text" class="input-small" id="scroll_offset" name="scroll_offset" value="<?php echo htmlspecialchars($options['scroll_offset'], ENT_QUOTES); ?>" style="text-align: right;">
				<br /><small>Please set scrolling offset. Subscribe popup appears only if user scroll down this number of pixels.</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
		<h3>OnIdle Popup Settings</h3>
		<div class="row">
			<div class="span3"><strong>Enable OnIdle Popup:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="idle_enable" name="idle_enable"<?php echo ($options['idle_enable'] == 'on' ? ' checked="checked"' : ''); ?>"> Enable OnIdle popup
				</label>
				<small>Please tick checkbox if you want to enable OnIdle popup. OnIdle popup appears after defined period of inactivity.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Idle period (seconds):</strong></div>
			<div class="span9">
				<input type="text" class="input-small" id="idle_delay" name="idle_delay" value="<?php echo htmlspecialchars($options['idle_delay'], ENT_QUOTES); ?>" style="text-align: right;">
				<br /><small>Please set idle period. Subscribe popup appears after this period of inactivity.</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
		<h3>OnContextMenu Popup Settings</h3>
		<div class="row">
			<div class="span3"><strong>Enable OnContextMenu Popup:</strong></div>
			<div class="span9">
				<label class="checkbox">
					<input type="checkbox" id="context_enable" name="context_enable"<?php echo ($options['context_enable'] == 'on' ? ' checked="checked"' : ''); ?>"> Enable OnContextMenu popup
				</label>
				<small>Please tick checkbox if you want to enable OnContextMenu popup. OnContextMenu popup appears once user call context menu (click right mouse button).</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
		<h3>Admin Settings</h3>
		<div class="row">
			<div class="span3"><strong>Login:</strong></div>
			<div class="span9">
				<input type="text" class="input-large" autocomplete="off" name="login" value="<?php echo htmlspecialchars($options['login'], ENT_QUOTES); ?>">
				<br /><small>Please set admin access login.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Password:</strong></div>
			<div class="span9">
				<input type="password" class="input-large" autocomplete="off" name="password" value="">
				<br /><small>Please set admin access password. Leave this field blank if you don't want to change current password.</small>
			</div>
		</div>
		<div class="row">
			<div class="span3"><strong>Confirm password:</strong></div>
			<div class="span9">
				<input type="password" class="input-large" autocomplete="off" name="confirm_password" value="">
				<br /><small>Please confirm admin access password.</small>
			</div>
		</div>
		<div class="row">
			<div class="span12">
				<input type="submit" class="btn btn-primary pull-right" name="submit" value="Update Settings">
			</div>
		</div>
		<hr>
	</form>
	<script type="text/javascript">
		function icontact_validate() {
			var icontact_appid = jQuery("#icontact_appid").val();
			var icontact_apiusername = jQuery("#icontact_apiusername").val();
			var icontact_apipassword = jQuery("#icontact_apipassword").val();
			jQuery("#icontact_progress").fadeIn(300);
			jQuery("#icontact_status").fadeOut(300);
			var data = {icontact_appid: icontact_appid, icontact_apiusername: icontact_apiusername, icontact_apipassword: icontact_apipassword, action: "icontact_validate"};
			jQuery.post("admin.php?action=icontact-validate", data, function(data) {
				jQuery("#icontact_status").html(data);
				jQuery("#icontact_progress").fadeOut(300);
				jQuery("#icontact_status").fadeIn(300);
			});
		}
		var active_icontact_appid = "";
		var active_icontact_apiusername = "";
		var active_icontact_apipassword = "";
		function icontact_loadlist() {
			if (active_icontact_appid != jQuery("#icontact_appid").val() || 
				active_icontact_apiusername != jQuery("#icontact_apiusername").val() ||
				active_icontact_apipassword != jQuery("#icontact_apipassword").val()) {
				jQuery("#icontact_listid").html("<option>-- Loading Lists --</option>");
				jQuery("#icontact_listid").attr("disabled", "disabled");
				jQuery.post("admin.php?action=icontact-lists", {
						"icontact_appid": jQuery("#icontact_appid").val(),
						"icontact_apiusername": jQuery("#icontact_apiusername").val(),
						"icontact_apipassword": jQuery("#icontact_apipassword").val()
					},
					function(return_data) {
						try {
							data = jQuery.parseJSON(return_data);
							if (data) {
								jQuery("#icontact_listid").html(data.options);
								jQuery("#icontact_listid").removeAttr("disabled");
								active_icontact_appid = jQuery("#icontact_appid").val();
								active_icontact_apiusername = jQuery("#icontact_apiusername").val();
								active_icontact_apipassword = jQuery("#icontact_apipassword").val();
							} else jQuery("#icontact_listid").html("<option>-- Can't get Lists --</option>");
						} catch(e) {
							jQuery("#icontact_listid").html("<option>-- Can't get Lists --</option>");
						}
					}
				);
			}
		}
		var active_getresponse_api_key = "";
		function getresponse_loadlist() {
			if (active_getresponse_api_key != jQuery("#getresponse_api_key").val()) {
				jQuery("#getresponse_campaign_id").html("<option>-- Loading Campaigns --</option>");
				jQuery("#getresponse_campaign_id").attr("disabled", "disabled");
				jQuery.post("admin.php?action=getresponse-campaigns", {
						"getresponse_api_key": jQuery("#getresponse_api_key").val()
					},
					function(return_data) {
						try {
							data = jQuery.parseJSON(return_data);
							if (data) {
								jQuery("#getresponse_campaign_id").html(data.options);
								jQuery("#getresponse_campaign_id").removeAttr("disabled");
								active_getresponse_api_key = jQuery("#getresponse_api_key").val();
							} else jQuery("#getresponse_campaign_id").html("<option>-- Can't get Campaigns --</option>");
						} catch(e) {
							jQuery("#getresponse_campaign_id").html("<option>-- Can't get Campaigns --</option>");
						}
					}
				);
			}
		}
		icontact_loadlist();
		getresponse_loadlist();
	</script>
<?php 
	} else if ($page == 'subscribers') {
		if (empty($error_message)) {
			if (!empty($ok_message)) $message = '<div class="alert alert-success">'.$ok_message.'</div>';
			else if (DEMO_MODE) $message = '<div class="alert alert-warning">Real e-mails are hidden in demo mode.</div>';
			else $message = '';
		} else $message = '<div class="alert alert-error">'.$error_message.'</div>';
		echo $message;

		if (isset($_GET["s"])) $search_query = trim(stripslashes($_GET["s"]));
		else $search_query = "";
		
		$tmp = $icdb->get_row("SELECT COUNT(*) AS total FROM ".$icdb->prefix."users WHERE deleted = '0'".((strlen($search_query) > 0) ? " AND (name LIKE '%".addslashes($search_query)."%' OR email LIKE '%".addslashes($search_query)."%')" : ""));
		$total = $tmp["total"];
		$totalpages = ceil($total/RECORDS_PER_PAGE);
		if ($totalpages == 0) $totalpages = 1;
		if (isset($_GET["p"])) $page = intval($_GET["p"]);
		else $page = 1;
		if ($page < 1 || $page > $totalpages) $page = 1;
		$switcher = page_switcher("admin.php?page=subscribers".((strlen($search_query) > 0) ? "&s=".rawurlencode($search_query) : ""), $page, $totalpages);

		$sql = "SELECT * FROM ".$icdb->prefix."users WHERE deleted = '0'".((strlen($search_query) > 0) ? " AND (name LIKE '%".addslashes($search_query)."%' OR email LIKE '%".addslashes($search_query)."%')" : "")." ORDER BY registered DESC LIMIT ".(($page-1)*RECORDS_PER_PAGE).", ".RECORDS_PER_PAGE;
		$rows = $icdb->get_rows($sql);
?>
	<h3>Subscribers</h3>
	<form action="admin.php" method="get" style="margin-bottom: 10px;">
		<input type="hidden" name="page" value="subscribers" />
		<input type="text" name="s" value="<?php echo htmlspecialchars($search_query, ENT_QUOTES); ?>">
		<input type="submit" class="btn" value="Search" />
		<?php echo (strlen($search_query) > 0 ? '<input type="button" class="btn" value="Reset search results" onclick="window.location.href=\'admin.php?page=subscribers\';" />' : ''); ?>
	</form>
	<div class="row">
		<div class="span12">
			<div class="btn-group pull-right">
				<a class="btn btn-primary" href="admin.php?action=export">CSV Export</a>
			</div>
		</div>
	</div>
	<table class="table table-striped">
		<tr>
			<th>Name</th>
			<th>E-mail</th>
			<th style="width: 120px;">Registered</th>
			<th style="width: 25px;"></th>
		</tr>
<?php		
		if (sizeof($rows) > 0) {
			foreach ($rows as $row) {
				$email = $row['email'];
				if (DEMO_MODE) {
					if (($pos = strpos($email, "@")) !== false) {
						$name = substr($email, 0, strpos($email, "@"));
						$email = substr($name, 0, 1).'*****'.substr($email, $pos);
					}
				}
				print ('
		<tr>
			<td>'.(empty($row['name']) ? '-' : htmlspecialchars($row['name'], ENT_QUOTES)).'</td>
			<td>'.htmlspecialchars($email, ENT_QUOTES).'</td>
			<td>'.date("Y-m-d H:i", $row['registered']).'</td>
			<td style="text-align: center;">
				<a href="admin.php?action=delete&id='.$row['id'].'" title="Delete record" onclick="return aiosp_submitOperation();"><img src="img/delete.png" alt="Delete record" border="0"></a>
			</td>
		</tr>');
			}
		} else {
			print ('
				<tr><td colspan="4" style="padding: 20px; text-align: center;">'.((strlen($search_query) > 0) ? 'No results found for "<strong>'.htmlspecialchars($search_query, ENT_QUOTES).'</strong>"' : 'List is empty.').'</td></tr>');
		}
?>
	</table>
	<div class="row">
		<div class="span6">
			<div class="pull-left">
			<?php echo $switcher; ?>
			&nbsp;
			</div>
		</div>
		<div class="span6">
			<div class="btn-group pull-right">
				<a class="btn btn-primary" href="admin.php?action=delete-all" onclick="return aiosp_submitOperation();">Delete All</a>
				<a class="btn btn-primary" href="admin.php?action=export">CSV Export</a>
			</div>
		</div>
	</div>
	<hr>
	<script type="text/javascript">
		function aiosp_submitOperation() {
			var answer = confirm("Do you really want to continue?");
			if (answer) return true;
			else return false;
		}
	</script>
<?php
	} else if ($page == 'embed') {
		if (empty($error_message)) {
			if (!empty($ok_message)) $message = '<div class="alert alert-success">'.$ok_message.'</div>';
			else $message = '';
		} else $message = '<div class="alert alert-error">'.$error_message.'</div>';
		echo $message;
		$url_base = '//'.$_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"];
		$filename = basename(__FILE__);
		if (($pos = strpos($url_base, $filename)) !== false) $url_base = substr($url_base, 0, $pos);
?>
	<h3>Embed popup into website</h3>
	<ol class="embed-list">
		<li>
		Make sure that your website loads jQuery. If it doesn't, just add this line into <code>head</code> section:
		<br /><code>&lt;script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"&gt;&lt;/script&gt;</code>
		</li>
		<li>
		Add these lines into <code>head</code> section (before <code>&lt;/head&gt;</code> tag):
		<br /><code>&lt;link href="<?php echo $url_base; ?>css/aiosp.css?ver=<?php echo $options['version']; ?>" rel="stylesheet"&gt;</code>
		<br /><code>&lt;script src="<?php echo $url_base; ?>js/aiosp-jsonp.js?ver=<?php echo $options['version']; ?>"&gt;&lt;/script&gt;</code>
		</li>
		<li>
		That's it! Enjoy!
		</li>
	</ol>
<?php
	} else if ($page == 'login') {
		if (empty($error_message)) {
			if (!empty($ok_message)) $message = '<div class="alert alert-success">'.$ok_message.'</div>';
			else $message = '';
		} else $message = '<div class="alert alert-error">'.$error_message.'</div>';
		echo $message;
?>
	<div class="loginbox">
		<h4 style="text-align: center;">Admin Panel</h4>
		<div style="margin-top: 10px; margin-left: 20px;">
		<form class="form-inline" method="post" action="admin.php?action=login">
			<input type="text" class="input-medium" name="login" placeholder="Login">
			<input type="password" class="input-medium" name="password" placeholder="Password">
			<button type="submit" class="btn btn-primary">Sign in</button>
		</form>
		</div>
	</div>
<?php
	}
?>

</div>

<!-- Footer - begin -->
<div class="navbar navbar-fixed-bottom navbar-inverse">
	<div class="navbar-inner">
		<div class="container">
			<p class="navbar-text pull-left">All-in-One Subscribe Popup, ver. <?php echo $options['version']; ?></p>
			<p class="navbar-text pull-right">Copyright &copy; 2011-<?php echo date('Y'); ?> <a href="http://www.icprojects.net/" target="_blank">Ivan Churakov</a></p>
		</div>
	</div>
</div>
<!-- Footer - end -->
</body>
</html>